<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Status extends Model 
{

    protected $table = 'statuses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function orders()
    {
        return $this->belongsToMany('App\Models\Order', 'order_statuses', 'status_id', 'order_id')->withTimestamps();
    }

}